#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.11.5
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]
library("tolerance")


lot <- c(rep("A", 6), rep("B", 6), rep("C",6))
vialn <- seq(1, 18, 1)
month <- rep(seq(0, 30, 6), 3)
conc <- c(102.1, 101.4, 101, 101.1, 100.8, 
          99.6, 100, 100, 100.2, 98.8, 99.8, 
          99, 97.6, 98.3, 98.1, 97.1, 96.5, 96)  
table236DS <- data.frame(Lot = lot, Vial = vialn, Concentration = conc, Time = month)  
table236DS

table236DS <- within(table236DS, {
  lot.a <- ifelse(Lot=="A", 1, ifelse(Lot=="B", 0, -1)) 
  lot.b <- ifelse(Lot=="B", 1, ifelse(Lot=="A", 0, -1)) 
  laxt <- lot.a*Time
  lbxt <- lot.b*Time
})

#---     Equal slopes across lots           -------#
table236.fit1 <- lm(Concentration ~ Time + lot.a + lot.b, data=table236DS)
summary(table236.fit1)
newds <- data.frame(Time=30, lot.a = 1, lot.b = 0)
predict(table236.fit1, newds, interval="confidence")
predict(table236.fit1, newds, interval="prediction")
out <- regtol.int(table236.fit1, new.x = newds, alpha=0.05, P=0.99, side=2)
out

#---     Unequal slopes across lots      --------#
table236.fit2 <- lm(Concentration ~ Time + lot.a + lot.b + laxt + lbxt, data = table236DS)
summary(table236.fit2)

newds2 <- data.frame(Time = 30, lot.a = 1, lot.b = 0, laxt = 30, lbxt = 0)
predict(table236.fit2, newds2, interval="confidence")
predict(table236.fit2, newds2, interval="prediction")
out2 <- regtol.int(table236.fit2, new.x = newds2, alpha=0.05, P=0.99, side=2)
out2

cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#